﻿using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;
using VIMT.VIASchedulingService.Messages;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using System;
using System.Diagnostics;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.ViaLogin
{
    public class SendLoginToEcStep : FilterBase<ViaLoginStateObject>
    {
        public override void Execute(ViaLoginStateObject state)
        {
            var timer = new Stopwatch();
            timer.Start();
            if (!string.IsNullOrEmpty(state.FakeResponseType))
            {
                state.EcResponse = VistaMapperHelper.VistaLoginFakeResponse(state.FakeResponseType);
            }
            else
            {
                try
                {
                    state.EcResponse = state.EcRequest.SendReceive<VIMTVIAScheLIloginVIAResponse>(MessageProcessType.Local);
                }
                catch(Exception ex)
                {
                    Logger.Instance.Error("Failed EC Call: " + ex.Message);
                    throw;
                }
            }
            timer.Stop();
            state.EcProcessingTimeMs += (int)timer.ElapsedMilliseconds;
            if (state.EcResponse == null) throw new Exception("No EC Response was returned");
        }
    }
}
